<?php
  BIndex::Add('referers', 'file');
  BaseFileIndex::$noBuffering['referers'] = true;

  BEvent::HookInstanceOf('ReferersFileIndex', 'RenameKey', 'post moved');
  BEvent::HookInstanceOf('ReferersFileIndex', 'PostViewed', 'post viewed');

  BEvent::HookInstanceOf('ReferersFileIndex', array('ToFooter', true),
                         'ViewcountsFileIndex>PostHitsToFooter', 'posthook');
  BEvent::HookInstanceOf('ReferersFileIndex', 'ToFooter', 'post footer');

  BConfig::$strings += array(
    'referers' => '$.',
    'referers num' => '$ referer, s, , s, s',
    'referers: title' => 'Referers for &laquo;%s&raquo;',
    'referers: none' => 'No referers were tracked for this post yet.',
    'referers: external' => '$ that came from external resources.',
    'referers: total' => '...And $ overall.',
    'referers: visitors' => '($)',
    'referers: visitors num' => '$ visitor, s, , s, s'
  );

/* one-shot */
  $this->name = 'referers';
  $this->Caption('Ссылающиеся сайты', 'ru');
  $this->info['user files'] = array('ReferersFileIndex', 'UserFiles');
/* install ReferersFileIndex */
class ReferersFileIndex extends BaseHashOfIntHashesFileIndex {
  static $joinWithHits = null;   // set to true/false to override autodetection.
  static $countRobots = true;

  public $indexName = 'post-referers';
  public $reverseSort = true;

  function TotalOf($post) { return count( $this->Select($post) ); }

  function PostViewed($post) {
    $referer = &$_SERVER['HTTP_REFERER'];
    if ($referer and (!IsRobotAgent() or self::$countRobots)) {
      $this->Add($post, $referer);
    }
  }

  function ToFooter(&$footer, $post, $isPosthook = false) {
    self::$joinWithHits === null and self::$joinWithHits = BIndex::Exists('ViewCounts');

    if (!self::$joinWithHits or $isPosthook) {
      if ($total = $this->TotalOf($post)) {
        if (self::$joinWithHits) {
          $hits = array_pop($footer);
          $total = TranslateNumber('referers', $total);
          $footer[] = '<a rel="noindex nofollow" href="'.BConfig::$engineURL.'referers.php?post='.urlencode($post).'"'.
                      ' title="'.$total."\">$hits</a>";
        } else {
          $total = TranslateNumber('referers num', $total);
          $footer[] = '<a rel="noindex nofollow" href="'.BConfig::$engineURL.'referers.php?post='.urlencode($post).'"'.
                      '>'.$total.'</a>';
        }
      }
    }
  }

  static function UserFiles() { return self::FileOf(SingleInstanceOf(__CLASS__)->indexName); }
}

/* one-shot */
return;
?>

/* install referers.php */
<?php
require 'engine/page.php';

$post = trim( $_REQUEST['post'] );

if ($post === '') {
  $referer = &$_SERVER['HTTP_REFERER'];
  $referer or $referer = BConfig::$siteHome;
  RedirectTo($referer);
} else {
  $title = sprintf('<a href="%s">%s</a>', BPosts::UrlOf($post), BPosts::TitleOf($post, true));
  printf('<h2>'.Translate('referers: title').'</h2>', $title);

  $referers = BIndex::SelectFrom('referers', $post);
  if (!$referers) {
    echo '<strong>', Translate('referers: none'), '</strong>';
  } else {
    $ext = $referers;

      foreach ($ext as $referer => $comers) {
        if (strpos($referer, BConfig::$siteHome) === 0) {
          unset( $ext[$referer] );
        }
      }

    Output($ext, 'external');
    Output($referers, 'total');
  }
}

  function Output($referers, $info) {
    $count = TranslateNumber('referers num', count($referers));
    $info = Translate('referers: '.$info, "<strong>$count</strong>");

    echo '<em>',$info,'</em>',
         '<ol>';

    foreach ($referers as $referer => $comers) {
      $referer = htmlspecialchars($referer); ?>
      <li>
        <?=TranslateNumber('referers: visitors', $comers)?>
        <kbd style="color: gray"><?php echo preg_replace('~(//)([\w.-]+)(/)~', '\1<b style="color: black">\2</b>\3', $referer)?></kbd>
      </li><?
    }

    echo '</ol>';
  }
